# NFA extension
G16のexternalを使ってNFA計算を実装するための情報収集ページ。

## externalについて
- [external - Gaussian公式ページ](https://gaussian.com/external/)
    - Gau-XXXX.EInというファイルに構造情報(原子番号、座標、電荷、atom type、connectivity)が出力され、これを外部のプログラムに読ませて、エネルギーや<s>力</s>勾配をGau-XXXX.EOuに書き出せば、Gaussianがその情報を読み取ってくれる。
        - EOuファイルはフォーマット遵守の必要あり。
        - エネルギーのみ必要ならば勾配は全て0で良い。
    - externalを使ってNFAのエネルギーを出力させるようなスクリプトを書けば、NFA利用の敷居を下げることができるはずだ。
        - 実験系のユーザーを想定。
        - （意味があるかは不明だが）相互作用最大化の構造最適化も容易に実装できる。

## 構想
- externalで呼び出したg16にF0,F1,F2,F12の4回分の計算を実行させて各エネルギーを足し引きすればNFAのエネルギーが得られる。実装案は以下の２つ。
- 案１: F1, F2, F12という情報をatom typeに持たせて、外部スクリプトにEInを読ませて、それぞれのフラグメントのインプットファイルを出力させ、g16を実行させる。
    - 実装は比較的楽だが、atom typeをテキスト上でgjfファイルに書く必要があり、少し敷居が高くなるか？
- 案２: gviewでユーザにfragment=1,2,3の情報をgjfファイルに持たせて、外部スクリプトにgjfファイルを読ませて、それぞれのフラグメントのインプットファイルを出力させ、g16を実行させる。
    - EInには元のgjfファイル名の情報がないため、lsofを介してgjfファイル名を拾ってくる必要あり。
    - ユーザー側の操作がほぼgviewだけで完結するので、非計算系向け。

- 実装に際して、下記のサンプルスクリプトが参考になるはず。

## 参考用サンプル
### test0726\_mod
- G16本家のexteralサンプルインプット(の微修正版)
    - extuffexシェルスクリプトは$g16root/g16/bsdに入っている。これにPATHを通せば実行できる。
    - 外部でG16を呼び出してuff計算を実行する。
    - オリジナルのtest0726.comはシェルではなくバッチ版(extuffex.bat)を利用している。

### extscf\_sample
- exuffexをscf計算用に修正したシェルスクリプト
    - extscfにパスを通して使う。中で呼び出す用のインプットファイルのヘッダはR.headにかく。

### lmp-gaussian\_sample
- externalでLAMMPS(reaxff)を呼び出すpythonスクリプトを利用するサンプル
    - lmp-gaussianとLAMMPS(lmp\_serial)にパスを通せば使える。

### connectivity\_parser
- external用ではなく、ONIOMのインプットを読み込んで、Electronic-EmbeddingにおけるHigh-Model用の点電荷を出力するだけのpythonコード断片。
    - フラグメントを跨ぐ結合情報を取得する上で、このコード断片が使えるはず。

### [gauparse](https://github.com/ykanematsu/gauparse)
- Gausianのログファイルパーサ。

### extnfa\_TBD
- 上記スクリプト群をもとに途中まで作成したnfaのexternal実装。
    - 現状ではf0のインプットを内部で作って計算するのみ。
